/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	pgpEntropy.c - interfaces the PGP Utility Driver to the SDK-derived 
	               hashing and entropy code
	

	$Id: pgpEntropy.c,v 1.3 2000/08/01 00:14:37 pbj Exp $
____________________________________________________________________________*/

#include "pgpUDx.h"
#include "PGPsdkDriver.h"
#include "pgpEntropy.h"
#include "pgpMisc.h"

// prototypes
	ULONG
PGPWin32DriverRandomPoolMouseMoved(
	ULONG		bForceAdd,
	ULONG 		timerval_lo);

	ULONG
PGPWin32DriverRandomPoolAddKeystroke(
	ULONG		bForceAdd,
	ULONG 		timerval_lo, 
	ULONG		keyscan);

	VOID
PGPWin32DriverRandomPoolGetBytesEntropy(
	PUCHAR		buf,
	ULONG		len,
	ULONG		bitsRequested,
	PULONG		bitsProvided);

	ULONG
PGPWin32DriverRandomPoolGetEntropy(VOID);

	ULONG
pgpInitGlobalRandomPool(VOID);


//	______________________________________________________
//
//	Add a keystroke event to the random pool.

VOID
pgpEntropyAddKeystrokeEvent (
    IN ULONG	ulForceAdd,
    IN ULONG	ulEvent)
{
	ULONG		ulLo;

	pgpDriverGetHiResTime (&ulLo);

	PGPWin32DriverRandomPoolAddKeystroke (ulForceAdd, ulLo, ulEvent);
}


//	______________________________________________________
//
//	Add a mouse event to the random pool.

VOID
pgpEntropyAddMouseEvent (
    IN ULONG	ulForceAdd)
{
	ULONG		ulLo;

	pgpDriverGetHiResTime (&ulLo);

	PGPWin32DriverRandomPoolMouseMoved (ulForceAdd, ulLo);
}


//	______________________________________________________
//
//	Initialize the entropy pool 

VOID
pgpEntropyInit (VOID)
{
	pgpInitGlobalRandomPool ();

	pgpEntropyAddKeystrokeEvent (1, 0);
	pgpEntropyAddKeystrokeEvent (1, 0);
	pgpEntropyAddKeystrokeEvent (1, 0);
	pgpEntropyAddKeystrokeEvent (1, 0);
}


//	______________________________________________________
//
//	This is the function that processes the DeviceIoControl
//	call which is coming down from the Win32 application.

VOID
pgpEntropyProcessOperation (
	IN PPGPENTROPYSTRUCT	ppes,
	IN PVOID				pCriticalSection)
{
	switch (ppes->ulOperation) {

	case kPGPUDOperation_QueryEntropy :
		pgpDriverEnterCriticalSection (pCriticalSection, MUTEX);
		ppes->ulEntropyBits = PGPWin32DriverRandomPoolGetEntropy ();
		pgpDriverLeaveCriticalSection (pCriticalSection, MUTEX);
		ppes->ulError = kPGPUDError_NoErr;
		break;

	case kPGPUDOperation_GetEntropy :
		pgpDriverEnterCriticalSection (pCriticalSection, MUTEX);
		PGPWin32DriverRandomPoolGetBytesEntropy (
					ppes->ucEntropyBuffer, 
					ppes->ulBufferLength, 
					8*ppes->ulBufferLength, 
					&ppes->ulEntropyBits);
		pgpDriverLeaveCriticalSection (pCriticalSection, MUTEX);

		ppes->ulError = kPGPUDError_NoErr;
		break;

///	case kPGPUDOperation_PutEntropy :
///		break;

	default :
		ppes->ulError = kPGPUDError_UndefinedOperation;
		break;
	}
}
